// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/serial.mojom
//

package org.chromium.mojom.device.serial;

public final class ConnectionOptions extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int bitrate;
    public int dataBits;
    public int parityBit;
    public int stopBits;
    public boolean ctsFlowControl;
    public boolean hasCtsFlowControl;

    private ConnectionOptions(int version) {
        super(STRUCT_SIZE, version);
        bitrate = (int) 0L;
        dataBits = (int) DataBits.NONE;
        parityBit = (int) ParityBit.NONE;
        stopBits = (int) StopBits.NONE;
        hasCtsFlowControl = (boolean) false;
    }

    public ConnectionOptions() {
        this(0);
    }

    public static ConnectionOptions deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static ConnectionOptions decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        ConnectionOptions result = new ConnectionOptions(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.bitrate = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.dataBits = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.parityBit = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.stopBits = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.ctsFlowControl = decoder0.readBoolean(24, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.hasCtsFlowControl = decoder0.readBoolean(24, 1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(bitrate, 8);
        encoder0.encode(dataBits, 12);
        encoder0.encode(parityBit, 16);
        encoder0.encode(stopBits, 20);
        encoder0.encode(ctsFlowControl, 24, 0);
        encoder0.encode(hasCtsFlowControl, 24, 1);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        ConnectionOptions other = (ConnectionOptions) object;
        if (this.bitrate != other.bitrate)
            return false;
        if (this.dataBits != other.dataBits)
            return false;
        if (this.parityBit != other.parityBit)
            return false;
        if (this.stopBits != other.stopBits)
            return false;
        if (this.ctsFlowControl != other.ctsFlowControl)
            return false;
        if (this.hasCtsFlowControl != other.hasCtsFlowControl)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(bitrate);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(dataBits);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(parityBit);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(stopBits);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(ctsFlowControl);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(hasCtsFlowControl);
        return result;
    }
}

